#!/bin/bash
#
# make a PC/M boot disk with different systems,
# currently:	amdisk	Albrecht Mugler,
#		lzdisk	Linz
#
# synopsis:	buildsk.sh amdisk | lzdisk
#
# result codes:	0	ok,
#		1	user break,
#		2	missing needed command,
#		3	missing needed user file
#

REALYACTION="Yes"	# "No" for debug only

MYNAME=`basename $0`
SYSDSKDEV="/dev/fd1"
SYSDSKSZ="SCP640"
SYSDSKGO="scp624"
SYSDSKFM="preformated"	# preformated or nonformated

case "$1" in
	amdisk)
		SYSTYP="Albrecht Mugler"
		SYSFILE="am/PCMSYS.BIN"
		SYSTOOL="cpmtools/bin/*.*"
		;;
	lzdisk)
		SYSTYP="Linz"
		SYSFILE="<unknown>"
		SYSTOOL="cpmtools/bin/*.*"
		;;
	*)
		echo -en "$MYNAME: missing System Type as 1st argument ( amdisk | lzdisk )\n\a\n"
		exit 1
		;;
esac

message() {
	echo -en "$MYNAME: $*"
}

newline() {
	message "\n"
}

action() {
	echo -en "$MYNAME:\t$*\n"
	case "$REALYACTION" in
		Y | y | Yes | yes | YES )
			$*
			;;
		* )
			echo -en "(DO NOTHING)\n\n"
			;;
	esac
}

yesno() {
	read -n 1 -p "$MYNAME:($*) OK ?> " YNINP
	echo
	case "$YNINP" in
		Y | y | J | j )
			return 0
			;;
		N | n )
			return 1
			;;
		*)
			return 2
			;;
	esac
}

yesno_blocked() {
	while true; do
		yesno $*
		case "$?" in
			0)
				return 0
				;;
			1)
				return 1
				;;
			2 | * )	;;
		esac
	done
}

devinp() {
	let GOON=1
	while [ $GOON -ne 0 ]; do
		read -p "$MYNAME:($1)> " DEVINP
		if [ -z $DEVINP ]; then DEVINP=$SYSDSKDEV; fi
		if [ -b $DEVINP -a -r $DEVINP -a -w $DEVINP ]; then
			let GOON=0
			yesno_blocked $DEVINP
			case "$?" in
				0)
					SYSDSKDEV=$DEVINP
					;;
				1 | 2 | * )
					let GOON=1
					;;
			esac
		fi
	done
	return 0
}

status() {
	newline
	newline
	message "\tSystem Type:\t$SYSTYP\n"
	message "\tSystem File:\t$SYSFILE\n"
	message "\tSystem Tools:\t$SYSTOOL\n"
	message "\tDisk Size:\t$SYSDSKSZ (type of fdutils)\n"
	message "\tDisk Geometry:\t$SYSDSKGO (type of cpmtools)\n"
	newline
	message "\tDisk Device:\t$SYSDSKDEV\n"
	message "\tDisk Format:\t$SYSDSKFM\n"
	newline
	[ "$SYSDSKFM" = "preformated" ] && message "\t(YOU NEED AN  A L R E A D Y  LOW-LEVEL FORMATED DISK)\n"
	[ "$SYSDSKFM" = "nonformated" ] && message "\t(YOU WILL   L O S E   A L L  DISK CONTENT)\n"
	newline
	newline
}

build() {
	newline
	newline
	action "$SETFDPRM"
	newline
	#message "Wait 30 seconds to finish floppy drive init ... "
	#$SLEEP 30
	#echo -en "OK\n"
	newline
	action "$MKFSCPM"
	action "$CPMLS"
	action "$CPMCP"
	action "$CPMLS"
}


SLEEP=`which sleep`
if [ $? -ne 0 ]; then message "can't execute sleep"; exit 2; fi
DIRNAME=`which dirname`
if [ $? -ne 0 ]; then message "can't execute dirname"; exit 2; fi

if [ -z $CPM4L ]; then message "missing system environment \$CPM4L\n\a\n"; exit 2; fi
if [ ! -x $CPM4L/bin/setfdprm ]; then message "can't execute \$CPM4L/bin/setfdprm\n\a\n"; exit 2; fi
if [ ! -x $CPM4L/bin/mkfs.cpm ]; then message "can't execute \$CPM4L/bin/mkfs.cpm\n\a\n"; exit 2; fi
if [ ! -x $CPM4L/bin/cpmls ]; then message "can't execute \$CPM4L/bin/cpmls\n\a\n"; exit 2; fi
if [ ! -x $CPM4L/bin/cpmcp ]; then message "can't execute \$CPM4L/bin/cpmcp\n\a\n"; exit 2; fi

if [ ! -d `$DIRNAME "$SYSTOOL"` ]; then message "can't read System Tools $SYSTOOL\n\a\n"; exit 3; fi
if [ ! -r $SYSFILE ]; then message "can't read System File $SYSFILE\n\a\n"; exit 3; fi

SETFDPRM="$CPM4L/bin/setfdprm $SYSDSKDEV $SYSDSKSZ"
MKFSCPM="$CPM4L/bin/mkfs.cpm -f $SYSDSKGO -b $SYSFILE $SYSDSKDEV"
CPMLS="$CPM4L/bin/cpmls -f $SYSDSKGO -D $SYSDSKDEV"
CPMCP="$CPM4L/bin/cpmcp -f $SYSDSKGO $SYSDSKDEV $SYSTOOL 0:"


message "Now we will make a PC/M bootdisk.\n"
message "(EMERGENCY EXIT with ^C)\n"
status
message "Give me your disk drive device:\n"
devinp $SYSDSKDEV
status
yesno_blocked "insert disk, ready to go on"
[ $? -ne 0 ] && message "USERS BREAK\n\a\n" && exit 1
build
